using System;
using Server;
using Server.Misc;

namespace Server.Mobiles
{
	//[CorpseName( "a spider corpse" )]
	public class EvoSpiderSumHighest : BaseSummonedEvoSpider
	{
      [Constructable]
		public EvoSpiderSumHighest( Xanthos.Evo.EvoSpider master ) : base( master )
		{
			Body = 11;
			BaseSoundID = 1170;
// 			Hue = 46;

			SetStr( 200 );
			SetDex( 150 );
			SetInt( 50 );

			SetHits( 350 );
			SetStam( 150 );
			SetMana( 0 );

			SetDamage( 15, 20 );

			SetDamageType( ResistanceType.Physical, 40 );
			SetDamageType( ResistanceType.Poison, 60 );

			SetResistance( ResistanceType.Physical, 60, 70 );
			SetResistance( ResistanceType.Fire, 60, 70 );
			SetResistance( ResistanceType.Cold, 60, 70 );
			SetResistance( ResistanceType.Poison, 100 );
			SetResistance( ResistanceType.Energy, 60, 70 );

			SetSkill( SkillName.MagicResist, 110.0 );
			SetSkill( SkillName.Tactics, 120.0 );
			SetSkill( SkillName.Wrestling, 120.0 );
			SetSkill( SkillName.Poisoning, 100.0 );

			Fame = 0;
			Karma = 0;

			VirtualArmor = 40;
		}
		
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override Poison HitPoison{ get{ return Poison.Deadly; } }

		public EvoSpiderSumHighest( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}